# define the seperator character
set SEP ","

# open a new file, using the session id for a unique name
set fileid [open [file join $::SYSTEM_PATH tmp_files $SESSION.csv] w]
fconfigure $fileid -translation binary

set column_names [list id name icon class_ids inv ref type type_name is_active inherit_obj_class division_id profile_name location thumbnail cf_template_name cf_values menu_group ac_names labour_rule class_name full_object full_class]
puts $fileid \"[join $column_names \042${SEP}\042]\"

# start the loop on each object
foreach object $OBJECTS full_object $FULL_OBJECTS full_class $FULL_CLASSES {
	
	lappend object [lindex $full_class 1]
	lappend object $full_object
	lappend object $full_class

	# this call will set each column name as a variable with its correct value
	eval [list lassign $object] $column_names
	
	puts "name = $name"

	puts $fileid \"[join $object \042${SEP}\042]\"
}

# close the file
close $fileid

# start excel
if {[catch {
	eval exec [auto_execok start] \"\" \"[file join $::SYSTEM_PATH tmp_files $SESSION.csv]\" &
} R1]} {
	# we could be on a mac
	catch {exec open "[file join $::SYSTEM_PATH tmp_files $SESSION.csv]"}
}

# shut down this script
wife::send exit $SESSION

